#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=276488 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252698, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-13 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252699, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-13 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-13 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-13 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-13 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252805, 'Database Backup [database_backup_2025-04-14-00-00-06-v3-1-6.zip]', '2025-04-14 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (252999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 16:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 16:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 16:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253562, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-14 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-14 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-14 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-14 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253665, 'Database Backup [database_backup_2025-04-15-00-03-03-v3-1-6.zip]', '2025-04-15 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253906, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:610c:2b52:a525:73fc]', '2025-04-15 07:16:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (253999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254318, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-04-15 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254349, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-04-15 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254353, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-04-15 20:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-15 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-15 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-15 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254486, 'Database Backup [database_backup_2025-04-16-00-03-03-v3-1-6.zip]', '2025-04-16 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 01:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 01:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 01:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255198, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-16 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255199, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-16 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255305, 'Database Backup [database_backup_2025-04-17-00-05-02-v3-1-6.zip]', '2025-04-17 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-04-17 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256078, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-17 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256190, 'Database Backup [database_backup_2025-04-18-00-03-10-v3-1-6.zip]', '2025-04-18 00:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256576, 'Failed to connect to IMAP auto importing tickets for d