#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=165567 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-27 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-27 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-27 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142631, 'Database Backup [database_backup_2024-11-28-00-02-02-v3-1-6.zip]', '2024-11-28 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 00:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 00:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 00:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (142999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-28 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-28 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-28 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143412, 'Database Backup [database_backup_2024-11-29-00-05-02-v3-1-6.zip]', '2024-11-29 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 06:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 06:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 06:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 12:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 12:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 12:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (143999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144094, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-11-29 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-29 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-29 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-29 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144194, 'Database Backup [database_backup_2024-11-30-00-04-02-v3-1-6.zip]', '2024-11-30 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144543, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.191]', '2024-11-30 10:57:00', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144970, 'Database Backup [database_backup_2024-12-01-00-02-02-v3-1-6.zip]', '2024-12-01 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145751, 'Database Backup [database_backup_2024-12-02-00-00-02-v3-1-6.zip]', '2024-12-02 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146313, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.191]', '2024-12-02 16:55:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:06:02', '[CRON]');
INSERT INTO `t