#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=108405 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 15:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 15:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 15:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84903, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.203]', '2024-09-16 16:40:26', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (84999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85039, 'Payment Recorded [ID:116, Invoice Number: INV-121/07/2024, Total: $1,500.00]', '2024-09-16 20:46:07', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85040, 'Email Sent To [Email: brinsley.smith@lobaxtt.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-09-16 20:46:13', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85041, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2024-09-16 20:46:15', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-16 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-16 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-16 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85156, 'Database Backup [database_backup_2024-09-17-00-03-02-v3-1-6.zip]', '2024-09-17 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 07:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 07:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 07:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85808, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.203]', '2024-09-17 19:37:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85809, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.203]', '2024-09-17 19:37:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-17 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-17 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-17 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85972, 'Database Backup [database_backup_2024-09-18-00-01-02-v3-1-6.zip]', '2024-09-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (85999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86648, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.203]', '2024-09-18 19:31:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86703, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86809, 'Database Backup [database_backup_2024-09-19-00-00-04-v3-1-6.zip]', '2024-09-19 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87620, 'Database Backup [database_backup_2024-09-20-00-00-05-v3-1-6.zip]', '2024-09-20 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88311, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.203]', '2024-09-20 20:36:26', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88429, 'Database Backup [database_backup_2024-09-21-00-04-03-v3-1-6.zip]', '2024-09-21 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88930, 'Failed to connect to IMAP auto importing tickets for department development@sayle