#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=203064 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179088, 'Database Backup [database_backup_2025-01-13-00-03-02-v3-1-6.zip]', '2025-01-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179794, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-13 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179795, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-13 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-13 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-13 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-13 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179895, 'Database Backup [database_backup_2025-01-14-00-00-05-v3-1-6.zip]', '2025-01-14 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (179999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-01-14 09:40:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 18:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 18:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 18:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180584, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-14 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180690, 'Database Backup [database_backup_2025-01-15-00-05-02-v3-1-6.zip]', '2025-01-15 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (180999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-15 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-15 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-15 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181495, 'Database Backup [database_backup_2025-01-16-00-04-02-v3-1-6.zip]', '2025-01-16 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (181999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182183, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-16 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182184, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-16 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-16 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-16 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-16 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182299, 'Database Backup [database_backup_2025-01-17-00-02-03-v3-1-6.zip]', '2025-01-17 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182