<?php

defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    db_prefix() . 'invoices.number as number',
    'company as client_name',
    db_prefix() . 'invoices.total as total',
    db_prefix() . 'invoices.recurring as recurring',
    'CASE WHEN ' . db_prefix() . 'invoices.cycles != 0 THEN CONCAT(' . db_prefix() . 'invoices.cycles - ' . db_prefix() . 'invoices.total_cycles, \' / \', ' . db_prefix() . 'invoices.cycles) ELSE "∞" end as cycles_info',
    db_prefix() . 'invoices.last_recurring_date',
    db_prefix() . 'invoices.date',
    db_prefix() . 'invoices.id',
];

$sIndexColumn = 'id';
$sTable       = db_prefix() . 'invoices';

$join = [
    'LEFT JOIN ' . db_prefix() . 'clients ON ' . db_prefix() . 'clients.userid = ' . db_prefix() . 'invoices.clientid',
];

$where = [
    'AND ' . db_prefix() . 'invoices.recurring != 0',
    'AND (' . db_prefix() . 'invoices.cycles = 0 OR ' . db_prefix() . 'invoices.cycles != ' . db_prefix() . 'invoices.total_cycles)',
    'AND ' . db_prefix() . 'invoices.status != 6', // Not draft
];

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    'clientid',
    'currency',
    'recurring_type',
    'custom_recurring',
    'cycles',
    'total_cycles',
    'last_recurring_date',
    db_prefix() . 'invoices.date as invoice_date',
    'status',
]);

$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];

    // Invoice number
    $numberOutput = '<a href="' . admin_url('invoices/list_invoices/' . $aRow['id']) . '" target="_blank">';
    $numberOutput .= format_invoice_number($aRow['id']);
    $numberOutput .= '</a>';
    $row[] = $numberOutput;

    // Client name
    $row[] = '<a href="' . admin_url('clients/client/' . $aRow['clientid']) . '" target="_blank">' . $aRow['client_name'] . '</a>';

    // Total amount
    $row[] = app_format_money($aRow['total'], get_currency($aRow['currency']));

    // Frequency
    if ($aRow['custom_recurring'] == 0) {
        $frequency = _l('invoice_add_edit_recurring_month' . ($aRow['recurring'] > 1 ? 's' : ''), $aRow['recurring']);
    } else {
        if ($aRow['recurring_type'] == 'day') {
            $frequency = _l('frequency_every', $aRow['recurring'] . ' ' . _l('invoice_recurring_days'));
        } elseif ($aRow['recurring_type'] == 'week') {
            $frequency = _l('frequency_every', $aRow['recurring'] . ' ' . _l('invoice_recurring_weeks'));
        } elseif ($aRow['recurring_type'] == 'month') {
            $frequency = _l('frequency_every', $aRow['recurring'] . ' ' . _l('invoice_recurring_months'));
        } elseif ($aRow['recurring_type'] == 'year') {
            $frequency = _l('frequency_every', $aRow['recurring'] . ' ' . _l('invoice_recurring_years'));
        }
    }
    $row[] = $frequency;

    // Cycles
    if ($aRow['cycles'] == 0) {
        $row[] = '<span class="label label-info">' . _l('cycles_infinity') . '</span>';
    } elseif ($aRow['cycles'] > 0 && $aRow['cycles'] == $aRow['total_cycles']) {
        $row[] = '<span class="label label-default">' . _l('recurring_has_ended', _l('invoice_lowercase')) . '</span>';
    } else {
        $remaining = $aRow['cycles'] - $aRow['total_cycles'];
        $row[] = '<span class="label label-primary">' . $remaining . ' / ' . $aRow['cycles'] . '</span>';
    }

    // Last recurring date
    if ($aRow['last_recurring_date']) {
        $row[] = _d($aRow['last_recurring_date']);
    } else {
        $row[] = '-';
    }

    // Next date (calculated)
    if (!$aRow['last_recurring_date']) {
        $last_date = date('Y-m-d', strtotime($aRow['invoice_date']));
    } else {
        $last_date = $aRow['last_recurring_date'];
    }

    if ($aRow['custom_recurring'] == 0) {
        $recurring_type = 'MONTH';
    } else {
        $recurring_type = $aRow['recurring_type'];
    }

    $next_date = date('Y-m-d', strtotime('+' . $aRow['recurring'] . ' ' . strtoupper($recurring_type), strtotime($last_date)));
    
    $next_date_formatted = _d($next_date);
    
    // Show warning if next date is in the past or today
    if (date('Y-m-d') >= $next_date) {
        $next_date_formatted = '<span class="text-danger"><i class="fa fa-exclamation-triangle"></i> ' . $next_date_formatted . '</span>';
    }
    
    $row[] = $next_date_formatted;

    // Actions
    $options = '<button type="button" class="btn btn-success btn-sm" onclick="generate_invoice(' . $aRow['id'] . ')">';
    $options .= '<i class="fa fa-refresh"></i> ' . _l('manual_recurring_invoices_generate_button');
    $options .= '</button>';

    $row[] = $options;

    $output['aaData'][] = $row;
}

echo json_encode($output);