# Manual Recurring Invoices Module for Perfex CRM

## Description
This module allows you to manually generate recurring invoices that have not yet been generated by the automatic cron job. This is useful when you need to create the next invoice immediately instead of waiting for the scheduled date.

## Features
- View all active recurring invoices in one place
- See the next scheduled generation date for each recurring invoice
- Manually generate the next invoice with a single click from the list page
- **NEW**: Generate next invoice directly from the invoice detail page (button in the More dropdown)
- Automatic calculation of invoice dates based on recurring settings
- Respects all Perfex recurring invoice settings (cycles, frequency, etc.)
- Automatically updates the last recurring date and cycle count
- Full integration with existing Perfex invoice functionality

## Installation

1. Upload the `manual_recurring_invoices` folder to your Perfex `modules/` directory
2. Navigate to **Setup → Modules** in your Perfex admin panel
3. Find "Manual Recurring Invoices" in the list and click **Activate**

## Usage

### Accessing the Module
After installation, you can access the module from:
- **Sales → Recurring Invoices** in the main menu

### Generating an Invoice

#### Method 1: From the List Page
1. Navigate to **Sales → Recurring Invoices**
2. You'll see a list of all active recurring invoices that haven't completed their cycles
3. Review the invoice details including:
   - Invoice number and client
   - Total amount
   - Frequency (how often it recurs)
   - Remaining cycles
   - Last generated date
   - Next scheduled date
4. Click the **Generate Next** button (green button with refresh icon) next to the invoice you want to generate
5. Confirm the action when prompted
6. The new invoice will be created and you'll be redirected to view it

#### Method 2: From the Invoice Detail Page
1. Open any recurring invoice (from **Sales → Invoices**)
2. In the "More" dropdown menu, you'll see a **Generate Next** link (with refresh icon)
3. Click the link and confirm the action
4. The new invoice will be created and you'll be redirected to view it

### Important Notes
- The module follows the same logic as Perfex's automatic cron job for recurring invoices
- Generated invoices respect your Perfex settings for:
  - Invoice status (draft, unpaid, or sent based on your configuration)
  - Email sending (automatic or manual)
  - Invoice numbering
  - Due date calculation
- The recurring invoice's "last generated date" and cycle count will be updated automatically
- You cannot generate invoices that have completed all their cycles
- Red-highlighted dates indicate invoices that are overdue for generation

## Permissions
The module includes the following permissions that can be assigned to staff roles:
- **View**: Access to view the manual recurring invoices page
- **Generate**: Ability to generate new invoices from recurring invoices

Configure permissions in **Setup → Roles** 

## Technical Details
- **Version**: 1.0.0
- **Requires**: Perfex CRM 2.3.* or higher
- **Compatible with**: All Perfex invoice settings and configurations
- **Database**: No additional database tables required (uses existing Perfex tables)

## How It Works
1. The module queries all recurring invoices that:
   - Have recurring enabled (recurring > 0)
   - Haven't completed all cycles (cycles = 0 OR cycles != total_cycles)
   - Are not in draft status
2. When you generate an invoice:
   - A new invoice is created with all data from the recurring invoice
   - The date is calculated based on the last generation date + recurring frequency
   - The due date is calculated based on your invoice settings
   - All items, taxes, custom fields, and tags are copied
   - The cycle count is incremented
   - The last recurring date is updated

## Support
For issues or questions, please contact your system administrator or Perfex CRM support.

## Changelog

### Version 1.0.0
- Initial release
- Basic recurring invoice generation functionality
- List view with all active recurring invoices
- Manual generation with one click
- Full integration with Perfex settings