<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1\Service;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class UsAppToPersonUsecaseOptions {
    /**
     * @param string $brandRegistrationSid A2P Brand Registration SID
     * @return FetchUsAppToPersonUsecaseOptions Options builder
     */
    public static function fetch(string $brandRegistrationSid = Values::NONE): FetchUsAppToPersonUsecaseOptions {
        return new FetchUsAppToPersonUsecaseOptions($brandRegistrationSid);
    }
}

class FetchUsAppToPersonUsecaseOptions extends Options {
    /**
     * @param string $brandRegistrationSid A2P Brand Registration SID
     */
    public function __construct(string $brandRegistrationSid = Values::NONE) {
        $this->options['brandRegistrationSid'] = $brandRegistrationSid;
    }

    /**
     * The unique string to identify the A2P brand.
     *
     * @param string $brandRegistrationSid A2P Brand Registration SID
     * @return $this Fluent Builder
     */
    public function setBrandRegistrationSid(string $brandRegistrationSid): self {
        $this->options['brandRegistrationSid'] = $brandRegistrationSid;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Messaging.V1.FetchUsAppToPersonUsecaseOptions ' . $options . ']';
    }
}