#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=343635 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319724, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319728, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319732, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319736, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319740, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319744, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319748, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319752, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319756, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319760, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319764, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319768, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319772, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319776, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319780, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319784, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319788, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319792, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319796, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319800, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319804, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319808, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319812, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319816, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319820, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319824, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319828, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319832, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319836, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319840, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319844, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319848, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319852, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319856, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319860, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319864, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319868, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319872, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319876, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319880, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319884, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:50:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319888, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319892, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319896, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319900, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319904, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319908, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319912, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319916, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319920, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319924, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319928, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319932, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319936, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319940, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319944, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319948, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319952, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319956, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319960, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319964, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319968, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319972, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319976, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319980, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319984, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319988, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319992, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319996, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320000, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320004, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320008, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320012, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320016, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320020, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320024, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320028, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320032, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320036, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320040, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320044, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320048, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320052, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320056, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320060, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320064, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320068, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320072, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320076, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320080, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320084, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320088, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320092, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320096, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320100, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320104, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320108, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320112, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320116, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320120, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320124, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320128, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320132, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320136, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320140, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320144, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320148, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320152, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320156, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320304, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320308, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320312, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320316, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320320, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320324, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320328, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320332, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320336, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320340, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320344, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 19:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320348, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 19:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320352, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 19:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320356, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 19:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320360, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 19:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320364, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 19:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320368, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 19:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320372, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 19:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320376, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 19:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320380, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 19:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320384, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 19:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320388, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 20:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320392, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 20:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320396, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 20:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320400, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 20:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320404, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 20:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320408, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 20:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320412, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 20:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320416, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 20:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320420, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 20:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320424, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 20:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 21:03:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 21:03:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 21:03:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320428, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 21:03:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320432, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 21:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320436, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 21:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320440, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 21:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320444, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 21:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320448, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 21:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320452, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 21:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320456, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 21:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320460, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 21:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320464, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 21:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320468, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 22:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320472, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 22:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320476, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 22:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320480, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 22:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320484, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 22:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320488, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 22:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320492, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 22:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 22:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 22:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 22:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320496, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 22:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320500, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 22:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320504, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 22:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320508, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 22:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320512, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 23:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320516, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 23:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320520, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 23:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320524, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 23:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320528, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 23:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320532, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 23:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320536, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 23:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320540, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 23:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320544, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 23:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320548, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 23:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320552, 'Database Backup [database_backup_2025-07-04-00-04-02-v3-1-6.zip]', '2025-07-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320553, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 00:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320557, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 00:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320561, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 00:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320565, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 00:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320569, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 00:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320573, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 00:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320577, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 00:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320581, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 00:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320585, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 00:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320589, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 00:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320593, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 01:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320597, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 01:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320601, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 01:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320605, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 01:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320609, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 01:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320613, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 01:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320617, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 01:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320621, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 01:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320625, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 01:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320629, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 01:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320633, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 02:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320637, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 02:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320641, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 02:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320645, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 02:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320649, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 02:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320653, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 02:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320657, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 02:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320661, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 02:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320665, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 02:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320669, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 02:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320673, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 02:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320677, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 03:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320681, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 03:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320685, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 03:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320689, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 03:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320693, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 03:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320697, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 03:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320701, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 03:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320705, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 03:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320709, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 03:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320713, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 03:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320717, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 04:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320721, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 04:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320725, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 04:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320729, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 04:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320733, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 04:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320737, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 04:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320741, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 04:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320745, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 04:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320749, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 04:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320753, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 04:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 05:00:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 05:00:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 05:00:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320757, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 05:00:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 05:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 05:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 05:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320761, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 05:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320765, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 05:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320769, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 05:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320773, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 05:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320777, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 05:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320781, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 05:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320785, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 05:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320789, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 05:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320793, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 05:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320797, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 05:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320801, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 06:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320805, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 06:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320809, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 06:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320813, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 06:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320817, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 06:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320821, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 06:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320825, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 06:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320829, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 06:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320833, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 06:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320837, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 06:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320841, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 07:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320845, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 07:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320849, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 07:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320853, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 07:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320857, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 07:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320861, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 07:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320865, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 07:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320869, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 07:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320873, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 07:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320877, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 07:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320881, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 08:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320885, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 08:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320889, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 08:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320893, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 08:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320897, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 08:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320901, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320905, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 08:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320909, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 08:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320913, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 08:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320917, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 08:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320921, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 08:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320925, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 09:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320929, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 09:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320933, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 09:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320937, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 09:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320941, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 09:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320945, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 09:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 09:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 09:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 09:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320949, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 09:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320953, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 09:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320957, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 09:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320961, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 09:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320965, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 10:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320969, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 10:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320973, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 10:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320977, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 10:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320981, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 10:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320985, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 10:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320989, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 10:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320993, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 10:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320997, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 10:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321001, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 10:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321005, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 11:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321009, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 11:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321013, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 11:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321017, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 11:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321021, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 11:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321025, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 11:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321029, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 11:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321033, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 11:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321037, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 11:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321041, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 11:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321045, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 12:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321049, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 12:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321053, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 12:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321057, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 12:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321061, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 12:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321065, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 12:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321069, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 12:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321073, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 12:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321077, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 12:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321081, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 12:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321085, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 13:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321089, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 13:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321093, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 13:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321097, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 13:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321101, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 13:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321105, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 13:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321109, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 13:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321113, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 13:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321117, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 13:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321121, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 13:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321125, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 14:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321129, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 14:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321133, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 14:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321137, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 14:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321141, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321145, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 14:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 14:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 14:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 14:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321149, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 14:35:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321153, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 14:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321157, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 14:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321161, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 14:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321165, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 14:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321169, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 15:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321173, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 15:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321177, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 15:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321181, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321185, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 15:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321189, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 15:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321193, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 15:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321197, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 15:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321201, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 15:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321205, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 15:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321209, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 16:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321213, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 16:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 16:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 16:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 16:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321217, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 16:13:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321221, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 16:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321225, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 16:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321229, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 16:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321233, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 16:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321237, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 16:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321241, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 16:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321245, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 16:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321249, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 16:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321253, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 17:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321257, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 17:10:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321261, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 17:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 17:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 17:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 17:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321265, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 17:21:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 17:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 17:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 17:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321269, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 17:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 17:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 17:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 17:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321273, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 17:33:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321277, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 17:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321281, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 17:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321285, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 17:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321289, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 17:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321293, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 18:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321297, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 18:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321301, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 18:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321305, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 18:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321309, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 18:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321313, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 18:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321317, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 18:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321321, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 18:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321325, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 18:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321329, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 18:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321333, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 18:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321337, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 19:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321341, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 19:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321345, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 19:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321349, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 19:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321353, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 19:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321357, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 19:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321361, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 19:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321365, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 19:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321369, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 19:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321373, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 19:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321377, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 20:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321381, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 20:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321385, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 20:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321389, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 20:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321393, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 20:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321397, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 20:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321401, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 20:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321405, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 20:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321409, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 20:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321413, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 20:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321417, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 20:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321421, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 21:04:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321425, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 21:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321429, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 21:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321433, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 21:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321437, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 21:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321441, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 21:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321445, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 21:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321449, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 21:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321453, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 21:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321457, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 21:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321461, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 22:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321465, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 22:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321469, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 22:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321473, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 22:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321477, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 22:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321481, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 22:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321485, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 22:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321489, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 22:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321493, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 22:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321497, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 22:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321501, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 22:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321505, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 23:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321509, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 23:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321513, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 23:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321517, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 23:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321521, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 23:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321525, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 23:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321529, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 23:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321533, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 23:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321537, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 23:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321541, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-04 23:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321545, 'Database Backup [database_backup_2025-07-05-00-02-04-v3-1-6.zip]', '2025-07-05 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321546, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 00:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321550, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 00:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321554, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 00:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321558, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 00:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321562, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 00:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321566, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 00:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321570, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 00:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321574, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 00:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321578, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 00:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321582, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 00:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321586, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 01:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321590, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 01:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321594, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 01:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321598, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 01:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321602, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 01:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321606, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 01:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321610, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 01:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321614, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 01:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321618, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 01:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321622, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 01:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321626, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 01:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321630, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 02:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321634, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 02:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321638, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 02:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321642, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 02:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321646, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 02:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321650, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 02:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321654, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 02:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321658, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 02:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321662, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 02:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321666, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 02:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321670, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 03:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321674, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 03:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321678, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 03:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321682, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 03:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 03:25:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 03:25:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 03:25:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321686, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 03:25:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321690, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 03:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321694, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 03:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321698, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 03:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321702, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 03:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321706, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 03:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321710, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321714, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321718, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321722, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321726, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321730, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321734, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321738, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321742, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321746, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321750, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321754, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321758, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321762, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321766, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321770, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321774, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321778, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321782, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321786, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321790, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321794, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321798, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321802, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321806, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321810, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321814, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321818, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321822, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321826, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321830, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321834, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321838, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321842, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321846, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321850, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321854, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321858, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321862, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321866, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321870, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321874, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321878, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321882, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321886, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321890, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321894, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321898, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321902, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321906, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321910, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321914, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321918, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321922, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321926, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321930, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321934, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321938, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321942, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321946, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321950, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321954, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321958, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321962, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321966, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321970, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321974, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321978, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321982, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321986, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321990, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321994, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321998, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322002, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322006, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322010, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322014, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322018, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322022, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322026, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322030, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322034, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322038, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322042, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322046, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322050, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322054, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322058, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322062, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322066, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322070, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322074, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322078, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322082, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322086, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322090, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322094, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322098, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322102, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322106, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:31:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322110, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322114, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322118, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322122, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322126, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322130, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322134, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322138, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322142, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322146, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322150, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322154, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322158, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322162, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322166, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:55:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322170, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:01:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322174, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322178, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322182, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322186, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322190, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322194, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322198, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322202, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322206, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322210, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322214, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322218, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:10:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322222, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322226, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322230, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322234, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322238, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322242, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322246, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322250, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322254, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322258, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322262, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322266, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322270, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322274, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322278, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322282, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322286, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322290, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322294, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322298, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322302, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322306, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:16:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322310, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322314, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322318, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322322, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322326, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322330, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322334, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322338, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322342, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322346, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322350, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322354, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322358, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322362, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322366, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322370, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322374, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322378, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322382, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322386, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322390, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322394, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322398, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322402, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322406, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322410, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322414, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322418, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322422, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322426, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322430, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322434, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322438, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322442, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322446, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322450, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322454, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322458, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322462, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322466, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322470, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322474, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322478, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322482, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322486, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322490, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322494, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322498, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322502, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322506, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322510, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322514, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322518, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322522, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322526, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322530, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322534, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322538, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322542, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322546, 'Database Backup [database_backup_2025-07-06-00-05-15-v3-1-6.zip]', '2025-07-06 00:05:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322547, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:05:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322551, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322555, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322559, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322560, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 00:25:19', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322561, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 00:25:50', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322562, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 00:26:20', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322563, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 00:26:46', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322567, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322571, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322575, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322579, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322583, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322587, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322591, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322595, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322599, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322603, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322607, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322611, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322612, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 01:39:44', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322613, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 01:40:08', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322977, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:e902:2b2a:f8dd:458]', '2025-07-06 13:16:54', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322978, 'Project Deleted [ID: 43, Name: Starter Website and Video Ad]', '2025-07-06 13:20:00', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322982, 'Project Deleted [ID: 47, Name: Website, Branding and Adroid and IOS Apps]', '2025-07-06 13:20:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322983, 'Task Attachment Deleted [TaskID: 159]', '2025-07-06 13:20:08', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322984, 'Project Deleted [ID: 22, Name: Business Website]', '2025-07-06 13:20:08', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322985, 'Project Deleted [ID: 23, Name: Ecommerce Website]', '2025-07-06 13:20:11', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322986, 'Project Deleted [ID: 24, Name: The Vegas Carnival]', '2025-07-06 13:20:14', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322987, 'Project Deleted [ID: 25, Name: Website Design]', '2025-07-06 13:20:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322988, 'Project Deleted [ID: 26, Name: Room Bookings Website]', '2025-07-06 13:20:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322989, 'Project Deleted [ID: 27, Name: Real Estate Booking Website]', '2025-07-06 13:20:23', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322990, 'Contract Deleted [17]', '2025-07-06 13:21:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322991, 'Contract Deleted [16]', '2025-07-06 13:21:08', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322992, 'Contract Deleted [12]', '2025-07-06 13:21:12', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322993, 'Contract Deleted [23]', '2025-07-06 13:21:16', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322994, 'Contract Deleted [2]', '2025-07-06 13:21:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323082, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:4470:3e1:d405:bc4d]', '2025-07-06 16:08:56', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323236, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-06 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323237, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-07-06 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323238, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-06 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323335, 'Database Backup [database_backup_2025-07-07-00-03-03-v3-3-1.zip]', '2025-07-07 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323822, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:cc9e:e2f5:f4c8:c6ba]', '2025-07-07 15:47:51', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323823, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:cc9e:e2f5:f4c8:c6ba]', '2025-07-07 15:47:51', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323986, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324080, 'Database Backup [database_backup_2025-07-08-00-03-02-v3-3-1.zip]', '2025-07-08 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324256, 'Failed to connect to IMAP auto importing tickets for departm