#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=116410 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93088, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-09-26 17:05:10', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93329, 'Database Backup [database_backup_2024-09-27-00-05-03-v3-1-6.zip]', '2024-09-27 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93717, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-09-27 12:02:30', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 19:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 19:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 19:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94015, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-09-27 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94118, 'Database Backup [database_backup_2024-09-28-00-04-02-v3-1-6.zip]', '2024-09-28 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 00:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 00:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 00:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 00:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 00:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 00:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 02:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 02:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 02:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 05:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 05:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 05:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94329, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-09-28 06:28:31', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 06:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 06:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 06:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 11:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 11:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 11:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 13:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 13:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 13:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 15:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 15:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 15:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 15:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 15:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 15:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 15:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 15:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 15:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 18:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 18:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 18:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 19:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 19:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 19:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 19:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 19:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 19:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 20:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 20:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 20:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 21:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 21:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 21:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-28 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-28 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-28 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94918, 'Database Backup [database_backup_2024-09-29-00-02-01-v3-1-6.zip]', '2024-09-29 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 00:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 00:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 00:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (94999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:48:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:48:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:48:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:01:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:01:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:01:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95714, 'Database Backup [database_backup_2024-09-30-00-04-01-v3-1-6.zip]', '2024-09-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96402, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-09-30 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96511, 'Database Backup [database_backup_2024-10-01-00-05-02-v3-1-6.zip]', '2024-10-01 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:08:01', '[CRON]');
INSERT INTO `tblactivity_lo