#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=133118 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 06:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 06:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 06:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 08:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 08:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 08:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 08:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 08:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 08:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 13:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 13:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 13:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 14:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 14:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 14:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 17:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 17:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 17:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108980, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.174]', '2024-10-16 17:23:01', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108984, 'Non Existing User Tried to Login [Email: bdallasferdinand@outlook.com, Is Staff Member: No, IP: 181.118.42.174]', '2024-10-16 17:24:37', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (108999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 18:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 18:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 18:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 19:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 19:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 19:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 20:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 20:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 20:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 22:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 22:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 22:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-16 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-16 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-16 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 00:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 00:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 00:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109204, 'Database Backup [database_backup_2024-10-17-00-03-01-v3-1-6.zip]', '2024-10-17 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 02:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 02:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 02:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 02:36:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 02:36:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 02:36:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 03:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 03:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 03:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 21:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 21:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 21:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109997, 'Database Backup [database_backup_2024-10-18-00-00-04-v3-1-6.zip]', '2024-10-18 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (109999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 09:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 09:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 09:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 11:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 11:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 11:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 12:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 12:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 12:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 19:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 19:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 19:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110628, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.174]', '2024-10-18 19:22:59', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 19:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 19:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 19:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110632, 'Non Existing User Tried to Login [Email: tishara.f@saylesstt.com, Is Staff Member: No, IP: 181.118.42.174]', '2024-10-18 19:30:08', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110633, 'Non Existing User Tried to Login [Email: tishara.f@saylesstt.com, Is Staff Member: No, IP: 181.118.42.174]', '2024-10-18 19:30:18', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110634, 'Non Existing User Tried to Login [Email: tishara.f@saylesstt.com, Is Staff Member: No, IP: 181.118.42.174]', '2024-10-18 19:30:23', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110635, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 181.118.42.174]', '2024-10-18 19:30:28', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110684, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-18 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110685, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Due Notice]', '2024-10-18 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 22:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 22:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 22:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-18 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-18 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-18 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110791, 'Database Backup [database_backup_2024-10-19-00-04-01-v3-1-6.zip]', '2024-10-19 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 02:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 02:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 02:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (110999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111128, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.174]', '2024-10-19 10:12:01', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111132, 'Client Deleted [ID: 61]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111134, 'Client Deleted [ID: 71]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111135, 'Client Deleted [ID: 82]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111136, 'Client Deleted [ID: 30]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111137, 'Client Deleted [ID: 101]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111138, 'Client Deleted [ID: 75]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111139, 'Client Deleted [ID: 62]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111140, 'Client Deleted [ID: 63]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111142, 'Client Deleted [ID: 27]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111143, 'Client Deleted [ID: 55]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111144, 'Client Deleted [ID: 56]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111145, 'Client Deleted [ID: 57]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111146, 'Client Deleted [ID: 58]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111148, 'Client Deleted [ID: 37]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111150, 'Client Deleted [ID: 43]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111151, 'Client Deleted [ID: 76]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111152, 'Client Deleted [ID: 34]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111154, 'Client Deleted [ID: 72]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111155, 'Client Deleted [ID: 14]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111156, 'Client Deleted [ID: 35]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111157, 'Client Deleted [ID: 26]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111158, 'Client Deleted [ID: 73]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111159, 'Client Deleted [ID: 74]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111160, 'Client Deleted [ID: 32]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111161, 'Client Deleted [ID: 25]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111162, 'Client Deleted [ID: 42]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111163, 'Client Deleted [ID: 53]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111164, 'Client Deleted [ID: 54]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111165, 'Client Deleted [ID: 41]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111166, 'Client Deleted [ID: 33]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111167, 'Client Deleted [ID: 44]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111168, 'Client Deleted [ID: 49]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111170, 'Client Deleted [ID: 24]', '2024-10-19 10:15:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-19 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-19 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-19 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111627, 'Database Backup [database_backup_2024-10-20-00-03-02-v3-1-6.zip]', '2024-10-20 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 08:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 08:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 08:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (111999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 22:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 22:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 22:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-20 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-20 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-20 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112423, 'Database Backup [database_backup_2024-10-21-00-01-02-v3-1-6.zip]', '2024-10-21 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112715, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-10-21 08:50:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-21 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-21 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (112991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-21 17:13:03', '[CRON