#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=386173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375053, 'Database Backup [database_backup_2025-10-06-06-59-03-v3-3-1.zip]', '2025-10-06 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 16:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 16:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 16:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 15:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 15:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 15:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376320, 'Database Backup [database_backup_2025-10-08-00-04-02-v3-3-1.zip]', '2025-10-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376540, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 190.213.30.56]', '2025-10-08 07:17:16', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376556, 'Manual Recurring Invoice Generated [Invoice ID: 207 from Recurring Invoice: 177]', '2025-10-08 07:46:47', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376599, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: No, IP: 190.213.30.56]', '2025-10-08 09:05:49', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376600, 'Invoice Status Updated [Invoice Number: INV-194/10/2025, From: Unpaid To: Paid]', '2025-10-08 09:07:06', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376601, 'Payment Recorded [ID:141, Invoice Number: INV-194/10/2025, Total: $2,520.00]', '2025-10-08 09:07:06', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 15:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 15:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 15:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (376999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-08 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-08 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-08 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377067, 'Database Backup [database_backup_2025-10-09-00-03-02-v3-3-1.zip]', '2025-10-09 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:02:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:02:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:02:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377812, 'Database Backup [database_backup_2025-10-10-00-02-02-v3-3-1.zip]', '2025-10-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377915, 'Database Backup [database_backup_2025-10-13-07-06-03-v3-3-1.zip]', '2025-10-13 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378336, 'Invoice Status Updated [Invoice Number: INV-193/10/2025, From: Unpaid To: Overdue]', '2025-10-13 21:03:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:03:46', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:03:46', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:03:46', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379177, 'Database Backup [database_backup_2025-10-15-00-02-02-v3-3-1.zip]', '2025-10-15 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:14:02', '[CRON]');
IN