#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=187929 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163324, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.3]', '2024-12-24 04:02:53', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163979, 'Database Backup [database_backup_2024-12-25-00-04-02-v3-1-6.zip]', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164766, 'Database Backup [database_backup_2024-12-26-00-04-02-v3-1-6.zip]', '2024-12-26 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165088, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.166]', '2024-12-26 09:55:56', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165110, 'Invoice Status Updated [Invoice Number: INV-169/11/2024, From: Unpaid To: Overdue]', '2024-12-26 10:29:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165111, 'Invoice Status Updated [Invoice Number: INV-169/11/2024, From: Overdue To: Unpaid]', '2024-12-26 10:30:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165466, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-26 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165467, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165567, 'Database Backup [database_backup_2024-12-27-00-02-02-v3-1-6.zip]', '2024-12-27 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166258, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.166]', '2024-12-27 20:48:28', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166367, 'Database Backup [database_backup_2024-12-28-00-04-02-v3-1-6.zip]', '2024-12-28 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167154, 'Database Backup [database_backup_2024-12-29-00-03-02-v3-1-6.zip]', '2024-12-29 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167212, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.166]', '2024-12-29 01:45:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167747, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.166]', '2024-12-29 17:59:41', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-29 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-29 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (167765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-29 18:30:02', '[CRON]'